const jsdom = require("jsdom");
const {JSDOM} = jsdom;
const request = require('request');

class AppStoreUpdater{
  constructor(appID, country){
    this.appID = appID;
    this.country = country;

    this.paidURL = 'https://play.google.com/store/apps/collection/topselling_paid?gl=' + country;
    this.grossingURL = 'https://play.google.com/store/apps/collection/topgrossing?gl=' + country;
    this.freeURL = 'https://play.google.com/store/apps/collection/topselling_free?gl=' + country;
  }

  update(){
    let promise = new Promise(this._actuallyUpdate.bind(this));
    return promise;
  }

  _actuallyUpdate(resolve, reject){
    let returnObj = {
      'paid': 'N/A',
      'free': 'N/A',
      'grossing': 'N/A',
    };

    let that = this;
    Promise.all([
      this._getDataForURL(this.paidURL, 'paid'),
      this._getDataForURL(this.grossingURL, 'grossing'),
      this._getDataForURL(this.freeURL, 'free'),
    ]).then(function(values){
      values.forEach(function(data){
        if(data.body){
          let rank = that._parseHTMLWithData(data);
          if(!rank){
            rank = 'N/A';
          }
          returnObj[data.name] = rank;
        }
        resolve(returnObj);
      });
    })
    .catch(function(err){
      reject(err);
    });
  }

  _parseHTMLWithData(data){
    let dom = new JSDOM(data.body);
    if(!dom){
      return null;
    }

    let $ = dom.window.document;
    let appElem = $.querySelector('div.card[data-docid="' + this.appID + '"]');

    if(!appElem){
      return null;
    }

    let allApps = $.querySelectorAll('div.card');
    if(!allApps || !allApps.length){
      return null;
    }

    let ranking = Array.prototype.indexOf.call(allApps, appElem);
    if(ranking == -1){
      return null;
    }

    return (ranking+1);
  }

  _getDataForURL(url, name){  
    let that = this;
    let promise = new Promise(function(resolve, reject){
      let options = {
        url: url,
        headers: that._headers()
      };

      request(options, function(error, resp, body){
        if(resp.statusCode !== 200 || !body || !body.length){
          resolve({
            'body': null,
            'name': name
          });
          return;
        }

        resolve({
          'body': body,
          'name': name
        });
      });
    });

    return promise;    
  }

  //Private
  _headers(){
    return {};
  }
};

module.exports = AppStoreUpdater;
